﻿
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Runtime.InteropServices; // Clase para importar la DLL.
using System.Threading;
using System.Windows.Forms;
using System.Xml.Linq;


namespace WindowsApplication1
{
	internal static class HIDDLLInterface
	{
		//Declaramos todas las funciones.
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="Connect", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern bool hidConnect(int pHostWin);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="Disconnect", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern bool hidDisconnect();
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="GetItem", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int hidGetItem(int pIndex);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="GetItemCount", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int hidGetItemCount();
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="Read", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern bool hidRead(int pHandle, ref byte pData);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="Write", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern bool hidWrite(int pHandle, ref byte pData);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="ReadEx", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern bool hidReadEx(int pVendorID, int pProductID, ref byte pData);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="WriteEx", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern bool hidWriteEx(int pVendorID, int pProductID, ref byte pData);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="GetHandle", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int hidGetHandle(int pVendoID, int pProductID);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="GetVendorID", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int hidGetVendorID(int pHandle);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="GetProductID", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int hidGetProductID(int pHandle);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="GetVersion", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int hidGetVersion(int pHandle);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="GetVendorName", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int hidGetVendorName(int pHandle, string pText, int pLen);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="GetProductName", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int hidGetProductName(int pHandle, string pText, int pLen);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="GetSerialNumber", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int hidGetSerialNumber(int pHandle, string pText, int pLen);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="GetInputReportLength", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int hidGetInputReportLength(int pHandle);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="GetOutputReportLength", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int hidGetOutputReportLength(int pHandle);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="SetReadNotify", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern void hidSetReadNotify(int pHandle, bool pValue);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="IsReadNotifyEnabled", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern bool hidIsReadNotifyEnabled(int pHandle);
		[System.Runtime.InteropServices.DllImport("mcHID.dll", EntryPoint="IsAvailable", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern bool hidIsAvailable(int pVendorID, int pProductID);

		//Funciones para desplegar mensajes.

		[System.Runtime.InteropServices.DllImport("user32", EntryPoint="CallWindowProcA", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int CallWindowProc(int lpPrevWndFunc, int hwnd, int Msg, int wParam, int lParam);
		[System.Runtime.InteropServices.DllImport("user32", EntryPoint="SetWindowLongA", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int SetWindowLong(int hwnd, int nIndex, int dwNewLong);

		public delegate int SubClassProcDelegate(int hwnd, int msg, int wParam, int lParam);
		[System.Runtime.InteropServices.DllImport("USER32.DLL", EntryPoint="SetWindowLongA", ExactSpelling=true, CharSet=System.Runtime.InteropServices.CharSet.Ansi, SetLastError=true)]
		public static extern int DelegateSetWindowLong(int hwnd, int attr, SubClassProcDelegate lval);


		// Constantes de la aplicación.
		public const int WM_APP = 32768;
		public const short GWL_WNDPROC = -4;

		// Constantes de mensajes de HID.
		private const decimal WM_HID_EVENT = WM_APP + 200;
		private const short NOTIFY_PLUGGED = 1;
		private const short NOTIFY_UNPLUGGED = 2;
		private const short NOTIFY_CHANGED = 3;
		private const short NOTIFY_READ = 4;

		// Variables locales.
		private static int FPrevWinProc;
		private static int FWinHandle;
		private static SubClassProcDelegate Ref_WinProc = new SubClassProcDelegate(WinProc);
		private static object HostForm;

		//Espera a recibir un mensaje del controlador HOST y luego se conecta a el mediante la librería de 
		//Funciones.
		public static bool ConnectToHID(ref Form targetForm)
		{
			bool pHostWin = Convert.ToBoolean(targetForm.Handle);
            FWinHandle = Convert.ToInt32(FWinHandle);
			pHostWin = hidConnect(FWinHandle);
			FPrevWinProc = DelegateSetWindowLong(FWinHandle, GWL_WNDPROC, Ref_WinProc);
			HostForm = targetForm;
//INSTANT C# NOTE: Inserted the following 'return' since all code paths must return a value in C#:
			return false;
		}

		// Se desconecta del HOST.
		public static bool DisconnectFromHID()
		{
			bool tempDisconnectFromHID = false;
			tempDisconnectFromHID = hidDisconnect();
			SetWindowLong(FWinHandle, GWL_WNDPROC, FPrevWinProc);
			return tempDisconnectFromHID;
		}

		private static int WinProc(int pHWnd, int pMsg, int wParam, int lParam)
		{
			if (pMsg == WM_HID_EVENT)
			{
				switch (wParam)
				{

					// Mensaje de que un dispositivo se ha conectado al host.
					case NOTIFY_PLUGGED:
						HostForm.OnPlugged(lParam);
						// Mensaje de que un dispositivo se ha desconectado del host.
						break;
					case NOTIFY_UNPLUGGED:
						HostForm.OnUnplugged(lParam);
						// El controlador ha cambiado.
						break;
					case NOTIFY_CHANGED:
						HostForm.OnChanged();
						// Se he recibido un dato.
						break;
					case NOTIFY_READ:
						HostForm.OnRead(lParam);
						break;
				}
			}
			return CallWindowProc(FPrevWinProc, pHWnd, pMsg, wParam, lParam);

		}

        internal static void ConnectToHID(ref Form1 form1)
        {
            throw new NotImplementedException();
        }
    }
} 